/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.remconsq;

import com.ibm.hwmca.base.remconsq.CommPathInfo;
import com.ibm.hwmca.base.remconsq.RemoteConnectionServicesConstants;
import com.ibm.hwmca.base.remconsq.RemoteConnectionServicesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DateItemDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TimeItemDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class RemoteConnectionServicesBean
extends PanelBean
implements RemoteConnectionServicesConstants,
RemoteConnectionServicesErrorIds {
    private static final String TRACEMASK_T = "XRQDBENT";
    private static final String TRACEMASK_F = "XRQDBENF";
    private static final String TRACEMASK_D = "XRQDBEND";
    public static final int TTABLE_NUMCOLS = 4;
    public static final int WTABLE_NUMCOLS = 5;
    private LocalizableText queueStatus;
    private LocalizableText remoteConSrvStatus;
    private List transmittingReqTable;
    private int[] transmittingReqTableSelection;
    private List transmittingCommPathIDs;
    private List waitingReqTable;
    private int[] waitingReqTableSelection;
    private List waitingCommPathIDs;
    private FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RCSBean");

    public String getQueueStatusOutput() {
        Trace.trace(TRACEMASK_D, "<--> getQueueStatusOutput() (return: " + this.queueStatus.toString() + ")");
        return this.queueStatus.toString();
    }

    public void setQueueStatusOutput(LocalizableText queueStatus) {
        Trace.trace(TRACEMASK_D, "<--> setQueueStatusOutput(" + queueStatus + ")");
        this.queueStatus = queueStatus;
    }

    public void setQueueStatusActive(boolean active) {
        Trace.trace(TRACEMASK_T, "<--> setQueueStatusActive(" + active + ")");
        this.userTaskManager.setEnabled("OptionsMenu.HoldTheQueueItem", active);
        this.userTaskManager.setEnabled("OptionsMenu.ReleaseTheQueueItem", !active);
        if (active) {
            this.setQueueStatusOutput(RemoteConnectionServicesConstants.Q_ACTIVE);
        } else {
            this.setQueueStatusOutput(RemoteConnectionServicesConstants.Q_HOLDING);
        }
    }

    public String getRemoteConSrvOutput() {
        Trace.trace(TRACEMASK_D, "<--> getRemoteConSrvOutput() (return: " + this.remoteConSrvStatus.toString() + ")");
        return this.remoteConSrvStatus.toString();
    }

    public void setRemoteConSrvOutput(LocalizableText remoteConSrvStatus) {
        Trace.trace(TRACEMASK_D, "<--> setRemoteConSrvOutput(" + remoteConSrvStatus + ")");
        this.remoteConSrvStatus = remoteConSrvStatus;
    }

    public int getTransmittingReqTableRowStatus() {
        Trace.trace(TRACEMASK_D, "<--> getTransmittingReqTableRowStatus() (return: 3)");
        return 3;
    }

    public int getTransmittingReqTableRowCount() {
        Trace.trace(TRACEMASK_D, "<--> getTransmittingReqTableRowCount() (return: " + this.transmittingReqTable.size() + ")");
        return this.transmittingReqTable.size();
    }

    public ItemDescriptor[] getTransmittingReqTableRowAt(int index) {
        Trace.trace(TRACEMASK_D, "<--> getTransmittingReqTableRowAt(" + index + ")");
        boolean isValidIndex = index >= 0 && index < this.transmittingReqTable.size();
        StringBuffer trace = new StringBuffer("transmitting requests table row at " + index + ": ");
        if (isValidIndex) {
            trace.append(this.arrayToString((ItemDescriptor[])this.transmittingReqTable.get(index)));
        } else {
            trace.append("does not exist");
        }
        Trace.trace(TRACEMASK_D, trace.toString());
        if (isValidIndex) {
            return (ItemDescriptor[])this.transmittingReqTable.get(index);
        }
        return null;
    }

    public void setTransmittingReqTableRowAt(int index, ItemDescriptor[] items) {
    }

    public int[] getTransmittingReqTableSelection() {
        Trace.trace(TRACEMASK_D, "<--> getTransmittingReqTableSelection() (return: " + this.arrayToString(this.transmittingReqTableSelection) + ")");
        return this.transmittingReqTableSelection;
    }

    public void setTransmittingReqTableSelection(int[] selected) {
        Trace.trace(TRACEMASK_D, "<--> setTransmittingReqTableSelection(" + this.arrayToString(selected) + ")");
        this.transmittingReqTableSelection = selected;
    }

    public int getWaitingReqTableRowStatus() {
        Trace.trace(TRACEMASK_D, "<--> getWaitingReqTableRowStatus() (return: 3)");
        return 3;
    }

    public int getWaitingReqTableRowCount() {
        Trace.trace(TRACEMASK_D, "<--> getWaitingReqTableRowCount() (return: " + this.waitingReqTable.size() + ")");
        return this.waitingReqTable.size();
    }

    public ItemDescriptor[] getWaitingReqTableRowAt(int index) {
        Trace.trace(TRACEMASK_D, "<--> getWaitingReqTableRowAt(" + index + ")");
        boolean isValidIndex = index >= 0 && index < this.waitingReqTable.size();
        StringBuffer trace = new StringBuffer("waiting requests table row at " + index + ": ");
        if (isValidIndex) {
            trace.append(this.arrayToString((ItemDescriptor[])this.waitingReqTable.get(index)));
        } else {
            trace.append("does not exist");
        }
        Trace.trace(TRACEMASK_D, trace.toString());
        if (isValidIndex) {
            return (ItemDescriptor[])this.waitingReqTable.get(index);
        }
        return null;
    }

    public void setWaitingReqTableRowAt(int index, ItemDescriptor[] items) {
    }

    public int[] getWaitingReqTableSelection() {
        Trace.trace(TRACEMASK_D, "<--> getWaitingReqTableSelection() (return: " + this.arrayToString(this.waitingReqTableSelection) + ")");
        return this.waitingReqTableSelection;
    }

    public void setWaitingReqTableSelection(int[] selected) {
        Trace.trace(TRACEMASK_D, "<--> setWaitingReqTableSelection(" + this.arrayToString(selected) + ")");
        this.waitingReqTableSelection = selected;
    }

    public void setQueues(List[] commPaths) {
        Trace.trace(TRACEMASK_T, "--> setQueues(" + this.arrayToString(commPaths) + ")");
        Object commPath = null;
        Object commPathsIterator = null;
        try {
            this.transmittingReqTable = commPaths[0];
            this.waitingReqTable = commPaths[1];
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in setQueues()!  Error logged and closing panel!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- setQueues()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACEMASK_D, "<--> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACEMASK_D, "<--> save()");
    }

    public void load() {
        Trace.trace(TRACEMASK_T, "--> load()");
        CommPathInfo commPath = null;
        ListIterator info = null;
        try {
            this.transmittingReqTableSelection = new int[0];
            this.waitingReqTableSelection = new int[0];
            info = this.transmittingReqTable.listIterator();
            this.transmittingReqTable = new ArrayList();
            this.transmittingCommPathIDs = new ArrayList();
            while (info.hasNext()) {
                commPath = (CommPathInfo)info.next();
                this.transmittingCommPathIDs.add(new Integer(commPath.getId()));
                this.transmittingReqTable.add(this.buildQueueEntry(commPath, 4));
            }
            info = this.waitingReqTable.listIterator();
            this.waitingReqTable = new ArrayList();
            this.waitingCommPathIDs = new ArrayList();
            while (info.hasNext()) {
                commPath = (CommPathInfo)info.next();
                this.waitingCommPathIDs.add(new Integer(commPath.getId()));
                this.waitingReqTable.add(this.buildQueueEntry(commPath, 5));
            }
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in load()!  Error logged and closing panel!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- load()");
    }

    public void prepare() {
        Trace.trace(TRACEMASK_T, "<--> prepare()");
        this.setQueueStatusActive(this.getQueueStatusOutput().equals(RemoteConnectionServicesConstants.Q_ACTIVE.toString()));
    }

    public void update(Object obj) {
        Trace.trace(TRACEMASK_T, "--> update(<List of Maps>)");
        boolean commPathID = false;
        int position = 0;
        int listLength = 0;
        CommPathInfo commPath = null;
        Map updateInfo = null;
        String updateType = null;
        List updateList = null;
        try {
            updateList = (List)obj;
            listLength = updateList.size();
            for (int i = 0; i < listLength; ++i) {
                updateInfo = (Map)updateList.get(i);
                updateType = (String)updateInfo.get("updateType");
                Trace.trace(TRACEMASK_F, "panel update info (Map): " + updateInfo);
                if (updateType.equals("addedToWaiting")) {
                    commPath = (CommPathInfo)updateInfo.get("commPathObject");
                    position = (Integer)updateInfo.get("commPathPosition");
                    this.insertQueueEntry(this.waitingReqTable, this.buildQueueEntry(commPath, 5), this.waitingCommPathIDs, commPath.getId(), position);
                    continue;
                }
                if (updateType.equals("movedFromWaitingToActive")) {
                    commPath = (CommPathInfo)updateInfo.get("commPathObject");
                    position = this.findQueueEntry(this.waitingCommPathIDs, commPath.getId());
                    if (position >= 0) {
                        this.deleteQueueEntry(this.waitingReqTable, this.waitingCommPathIDs, position);
                    }
                    this.insertQueueEntry(this.transmittingReqTable, this.buildQueueEntry(commPath, 4), this.transmittingCommPathIDs, commPath.getId(), this.transmittingReqTable.size());
                    continue;
                }
                if (updateType.equals("removedFromActive")) {
                    commPath = (CommPathInfo)updateInfo.get("commPathObject");
                    position = this.findQueueEntry(this.transmittingCommPathIDs, commPath.getId());
                    if (position < 0) continue;
                    this.deleteQueueEntry(this.transmittingReqTable, this.transmittingCommPathIDs, position);
                    continue;
                }
                if (updateType.equals("removedFromWaiting")) {
                    commPath = (CommPathInfo)updateInfo.get("commPathObject");
                    position = this.findQueueEntry(this.waitingCommPathIDs, commPath.getId());
                    if (position < 0) continue;
                    this.deleteQueueEntry(this.waitingReqTable, this.waitingCommPathIDs, position);
                    continue;
                }
                if (!updateType.equals("reorderInWaiting")) continue;
                commPath = (CommPathInfo)updateInfo.get("commPathObject");
                position = this.findQueueEntry(this.waitingCommPathIDs, commPath.getId());
                if (position >= 0) {
                    this.deleteQueueEntry(this.waitingReqTable, this.waitingCommPathIDs, position);
                }
                position = (Integer)updateInfo.get("commPathPosition");
                this.insertQueueEntry(this.waitingReqTable, this.buildQueueEntry(commPath, 5), this.waitingCommPathIDs, commPath.getId(), position);
            }
            this.userTaskManager.refreshAllElements();
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in update()!  Error logged!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- update()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACEMASK_T, "--> panelAction(" + event + ")");
        int[] selectedCommPathIDs = null;
        PanelTaskletRequest request = null;
        String elementName = null;
        try {
            this.userTaskManager.storeElement("TransmittingReqTable");
            this.userTaskManager.storeElement("WaitingReqTable");
            request = new PanelTaskletRequest();
            request.setSource(this.getBeanName());
            elementName = event.getElementName();
            if (elementName.endsWith("PrioritizeItem")) {
                selectedCommPathIDs = new int[this.waitingReqTableSelection.length];
                for (int i = 0; i < selectedCommPathIDs.length; ++i) {
                    selectedCommPathIDs[i] = (Integer)this.waitingCommPathIDs.get(this.waitingReqTableSelection[i]);
                }
                request.setData("commpathids", selectedCommPathIDs);
                request.setData("command", "PrioritizeItem");
            } else if (elementName.endsWith("CancelSelectedItem")) {
                int i;
                selectedCommPathIDs = new int[this.transmittingReqTableSelection.length + this.waitingReqTableSelection.length];
                for (i = 0; i < this.transmittingReqTableSelection.length; ++i) {
                    selectedCommPathIDs[i] = (Integer)this.transmittingCommPathIDs.get(this.transmittingReqTableSelection[i]);
                }
                int j = i;
                for (i = 0; i < this.waitingReqTableSelection.length; ++i) {
                    selectedCommPathIDs[j++] = (Integer)this.waitingCommPathIDs.get(this.waitingReqTableSelection[i]);
                }
                request.setData("commpathids", selectedCommPathIDs);
                request.setData("command", "CancelSelectedItem");
            } else if (elementName.endsWith("CancelActiveItem")) {
                request.setData("commpathids", this.listToArrayOfInts(this.transmittingCommPathIDs));
                request.setData("command", "CancelSelectedItem");
            } else if (elementName.endsWith("CancelWaitingItem")) {
                request.setData("commpathids", this.listToArrayOfInts(this.waitingCommPathIDs));
                request.setData("command", "CancelSelectedItem");
            } else if (elementName.endsWith("HoldTheQueueItem")) {
                this.setQueueStatusActive(false);
                request.setData("command", "HoldTheQueueItem");
            } else if (elementName.endsWith("ReleaseTheQueueItem")) {
                this.setQueueStatusActive(true);
                request.setData("command", "ReleaseTheQueueItem");
            } else if (elementName.endsWith("ExitItem")) {
                request.setDisposed();
            } else if (event.getActionCommand().equals("CANCEL")) {
                request.setCanceled();
            } else {
                throw new Exception("Unknown element or action caused event!");
            }
            this.postTaskletRequest(request);
            this.userTaskManager.refreshAllElements();
        }
        catch (IllegalUserDataException iudEx) {
            throw iudEx;
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in panelAction()!  Error logged!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- panelAction()");
    }

    private String arrayToString(int[] array) {
        Trace.trace(TRACEMASK_D, "<-> arrayToString(<int[]>)");
        StringBuffer buffer = new StringBuffer("{ ");
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private String arrayToString(Object[] array) {
        Trace.trace(TRACEMASK_D, "<-> arrayToString(<Object[]>)");
        StringBuffer buffer = new StringBuffer("{ ");
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private int[] listToArrayOfInts(List ints) {
        Trace.trace(TRACEMASK_D, "<-> listToArrayOfInts(" + ints + ")");
        int[] intArray = new int[ints.size()];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = (Integer)ints.get(i);
        }
        return intArray;
    }

    private ItemDescriptor[] buildQueueEntry(CommPathInfo commPath, int numCols) {
        Trace.trace(TRACEMASK_T, "-> buildQueueEntry(" + commPath + ", " + numCols + ")");
        int index = 0;
        ItemDescriptor[] queueEntry = null;
        Object priority = null;
        queueEntry = new ItemDescriptor[numCols];
        queueEntry[index] = new ItemDescriptor(null, commPath.getSystem());
        ++index;
        if (numCols == 5) {
            queueEntry[index] = new ItemDescriptor(null, commPath.getPriority());
            ++index;
        }
        queueEntry[index] = new DateItemDescriptor(null, commPath.getDate());
        queueEntry[++index] = new TimeItemDescriptor(null, commPath.getDate());
        queueEntry[++index] = new ItemDescriptor(null, commPath.getDescription());
        Trace.trace(TRACEMASK_T, "<- buildQueueEntry() (return: " + queueEntry + ")");
        return queueEntry;
    }

    private void deleteQueueEntry(List table, List idList, int position) {
        Trace.trace(TRACEMASK_T, "-> deleteQueueEntry(<queue table>, " + this.arrayToString(idList.toArray()) + ", " + position + ")");
        table.remove(position);
        idList.remove(position);
        Trace.trace(TRACEMASK_T, "<- deleteQueueEntry()");
    }

    private int findQueueEntry(List idList, int id) {
        Trace.trace(TRACEMASK_T, "<-> findQueueEntry(" + this.arrayToString(idList.toArray()) + ", " + id + ")");
        for (int index = 0; index < idList.size(); ++index) {
            if ((Integer)idList.get(index) != id) continue;
            return index;
        }
        return -1;
    }

    private void insertQueueEntry(List table, ItemDescriptor[] row, List idList, int id, int position) {
        Trace.trace(TRACEMASK_T, "-> insertQueueEntry(<queue table>, " + this.arrayToString(row) + ", " + this.arrayToString(idList.toArray()) + ", " + id + ", " + position + ")");
        table.add(position, row);
        idList.add(position, new Integer(id));
        Trace.trace(TRACEMASK_T, "<- insertQueueEntry()");
    }
}

